//Compute DFT using matrix approach & then using DFT properties.
//  (i)  :  x(n)={1,2,3,4), find DFT X(k)
//  (ii) :  Using results obtained in part (i) & not otherwise,
// find DFT of following sequences :
// x1(n)={4,1,2,3}
// x2(n)={2,3,4,1}
// x3(n)={3,4,1,2}
// x4(n)={4,6,4,6}
//Software version Scilab 5.5.2
//OS windows 10
clc;
clear;
//Let us first define the W4 matrix
W4=[1 1 1 1 ;1 -sqrt(-1) -1 sqrt(-1);1 -1 1 -1;1 sqrt(-1) -1 -sqrt(-1)];
disp(W4,'W4=')
//Now let us define the input sequence
xn=[1;2;3;4];//The input sequence x(n)has been arranged as a column matrix
//DFT is obtained by multiplying the twiddle matrix W4 and the input sequence
Xk=W4*xn;
disp(Xk,'DFT : X(k)=')
disp('Type resume in console and press enter')
pause
X0=10
X1=-2+2*sqrt(-1);
X2=-2
X3=-2-2*sqrt(-1);

//(ii) :x1(n)={4,1,2,3} and x(n)={1,2,3,4}
//x1(n) is obtained by delaying x(n) by 1 position which means x1(n)=x(n-1)
//According to the circular time shift property : x(n-l) gives DFT as X(k)*e^(-j*2*%pi*k*l/N)
//But l=-1
a1=cos(0)-(sqrt(-1)*sin(0));
//So,for k=0,
X10=X0.*real(a1)-X0.*(sqrt(-1)*imag(a1))
disp(X10,'X1(0)=')
//So,for k=1,
b1=int(cos(%pi/2))-(sqrt(-1)*sin(%pi/2))
X11=X1*b1;
disp(X11,'X1(1)=')
//For k=2,
c1=int(cos(%pi))-int((sqrt(-1)*sin(%pi)));
X12=X2*c1;
disp(X12,'X1(2)=')
//For k=3,
d1=int(cos((3*%pi)/2))-int((sqrt(-1)*sin((3*%pi)/2)));
X13=X3*d1;
disp(X13,'X1(3)=')
disp({,X10,X11,X12,X13,},'So, X1(k)=')

// (iii) : Now moving ahead to find X2(k)
//x2(n)={2,3,4,1} and x(n)={1,2,3,4}
//x2(n) is obtained by advancing x(n) by 1 position which means x2(n)=x(n+1)
//According to the circular time shift property : x(n-l) gives DFT as X(k)*e^(-j*2*%pi*k*l/N)
//But l=2
a2=cos(0)+(sqrt(-1)*sin(0));
//So,for k=0,
X20=X0.*real(a2)-X0.*(sqrt(-1)*imag(a2))
disp(X20,'X2(0)=')
//So,for k=1,
b2=int(cos(%pi/2))+(sqrt(-1)*sin(%pi/2))
X21=X1*b2;
disp(X21,'X2(1)=')
//For k=2,
c2=int(cos(%pi))+int((sqrt(-1)*sin(%pi)));
X22=X2*c2;
disp(X22,'X2(2)=')
//For k=3,
d2=int(cos((3*%pi)/2))+int((sqrt(-1)*sin((3*%pi)/2)));
X23=X3*d2;
disp(X23,'X2(3)=')
disp({,X20,X21,X22,X23,},'So, X2(k)=')

// (iv) : Now moving ahead to find X3(k)
//x3(n)={3,4,1,2} and x(n)={1,2,3,4}
//x3(n) is obtained by shifting x(n) by 2 positions which means x3(n)=x[n(+/-)2]
//According to the circular time shift property : x[n(+/-)2] gives DFT as X(k)*e^(-j*2*%pi*k*l/N)
a3=cos(0)+(sqrt(-1)*sin(0));
//So,for k=0,
X30=X0.*real(a3)-X0.*(sqrt(-1)*imag(a3))
disp(X30,'X3(0)=')
//So,for k=1,
b3=int(cos(%pi))-(sqrt(-1)*sin(%pi))
X31=X1*b3;
disp(X31,'X3(1)=')
//For k=2,
c3=int(cos(2*%pi))-int((sqrt(-1)*sin(2*%pi)));
X32=X2*c3;
disp(X32,'X3(2)=')
//For k=3,
d3=int(cos(3*%pi))-int((sqrt(-1)*sin(3*%pi)));
X33=X3*d3;
disp(X33,'X3(3)=')
disp({,X30,X31,X32,X33,},'So, X3(k)=')

// (v) : Now moving ahead to find X4(k)
//x4(n)={4,6,4,6} and x(n)={1,2,3,4}
//Both are related as x4(n)=x(n)+x[n(+/-)2]
//Using half period shift property, X4(k)=X(k)+[(-1)^k]*X(k)
//For k=0,
X40=X0+[(-1)^0]*X0
disp(X40,'X40=')
//For k=1,
X41=X1+[(-1)^1]*X1
disp(X41,'X41=')
//For k=2,
X42=X2+[(-1)^2]*X2
disp(X42,'X42=')
//For k=3,
X43=X3+[(-1)^3]*X3
disp(X43,'X43=')
disp({,X40,X41,X42,X43,},'So, X4(k)=')
